# string.listDeleteAt()

Deletes an element from a list.
Returns a copy of the list, without the specified element.

```
string.listDeleteAt( position=number, delimiters=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| position | number | Yes | position of the element to delete |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	strList="This,is,listdeleteat,example";
	writeDump(strList.listDeleteAt(4));
	writeoutput("<br>");
	writedump("one@two@ @four".listDeleteAt(3,"@",true));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListDeleteAt()](../../functions/listdeleteat.md), [String](../string.md)