# string.listContainsNoCase()

Determines the index of the first list element that contains a
specified substring.

```
string.listContainsNoCase( substring=string, delimiters=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| substring | string | Yes | the string to search in the list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. |  |

# Examples

```cfml
	list = "I,love,lucee";
	writedump(list.ListContainsNoCase("LUCEE"));
	writeoutput("<br>");
	listOne = "lucee@core@dev";
	writedump(listOne.ListContainsNoCase("CORE","@"));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListContainsNoCase()](../../functions/listcontainsnocase.md), [String](../string.md)