# string.listCompact()

remove empty items at the end and at the start of the list

```
string.listCompact( delimiters=string, multiCharacterDelimiter=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. |  |

# Examples

```cfml
	listCompactone=",,,,1,2,3,4";
	writeDump(listCompactone.ListCompact());
	writeoutput("<br>");
	listCompactTwo="++++1+2+3+4";
	writeDump(listCompactTwo.ListCompact("+"));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListCompact()](../../functions/listcompact.md), [String](../string.md)