# string.listChangeDelims()

Changes a list delimiter.
Returns a copy of the list, with each delimiter character
replaced by new_delimiter.

```
string.listChangeDelims( new_delimiter=string, delimiters=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| new_delimiter | string | Yes | new delimiter to set. a delimiter is a characters that separate list elements. |  |
| delimiters | string | No | existing delimiter to replace. a delimiter is a characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the [ListToArray()](../../functions/listtoarray.md) function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. |  |

# Examples

```cfml
	strLst="1+2+3+4";
	writeDump(strLst.listChangeDelims("/", "+"));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListChangeDelims()](../../functions/listchangedelims.md), [String](../string.md)