# string.listAppend()

Concatenates a list or element to a list.

```
string.listAppend( value=string, delimiters=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | string | Yes | a string value |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. If this string contains more than one character, only the first character is used. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if false it cleans up empty fields. |  |

# Examples

```cfml
	mylist = "one,two,three";
	myNewlist = mylist.listAppend("four");
	writedump(myNewlist);
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListAppend()](../../functions/listappend.md), [String](../string.md)