# string.hash()

Converts a variable-length string to a 32-byte, hexadecimal
        string, using the MD5 algorithm. (It is not possible to convert
        the hash result back to the source string.)
        32-byte, hexadecimal string

```
string.hash( algorithm=string, encoding=string, numIterations=number )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| algorithm | string | No | The algorithm to use to hash the string. Supported are the following algorithms: - QUICK: generating a fast hash string, that provides no security. this algorithm is good when you simply need to shorten a string for an id, for example - CFMX_COMPAT: generating a hash string using classic CFML algorithm. - MD5: (default) Generates a 32-character, hexadecimal string, using the MD5 algorithm. - SHA: Generates a 28-character string using the Secure Hash Standard SHA-1 algorithm specified by Nation Institute of Standards and Technology (NIST) FIPS-180-2. - SHA-256: Generates a 44-character string using the SHA-256 algorithm specified by FIPS-180-2. - SHA-384: Generates a 64-character string using the SHA-384 algorithm specified by FIPS-180-2. - SHA-512: Generates an 88-character string using the SHA-1 algorithm specified by FIPS-180-2. |  |
| encoding | string | No | A string specifying the encoding to use when converting the string to byte data used by the hash algorithm. |  |
| numIterations | number | No | The number of times to iterate hashing. A greater number of iterations will result in a cryptographically stronger hash but will also take more time to generate that hash. The default value is 1. For algorithm quick, only 1 is allowed |  |

# Examples

*There are currently no examples for this function*

# Categories

[Strings](../../../categories/string.md)

# See Also

[Hash()](../../functions/hash.md), [String](../string.md)