# string.getToken()

Determines whether a token of the list in the delimiters
parameter is present in a string.
Returns the token found at position index of the string, as a
string. If index is greater than the number of tokens in the
string, returns an empty string.

```
string.getToken( index=number, delimiters=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| index | number | Yes | Positive integer. The position of a token. |  |
| delimiters | string | No | A delimited list of delimiters. Elements may consist of multiple characters. Default list of delimiters: space character, tab character, newline character; or their codes: "chr(32)", "chr(9)", chr(10). Default list delimiter: comma character. *Alias: delimiter* |  |

# Examples

```cfml
	token_test = "yellow,red:,orange,blue:;,lavender,pink:;";
	writedump(token_test.GetToken(2,":"));
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[GetToken()](../../functions/gettoken.md), [String](../string.md)