# string.findOneOf()

Finds the first occurrence of any one of a set of characters
in a string, from a specified start position. The search is
case-sensitive.

```
string.findOneOf( set=string, start=number )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| set | string | Yes | String that contains one or more characters to search for. |  |
| start | number | No | Start position of search. |  |

# Examples

```cfml
dump("I".findoneof("I Love Lucee"));
dump("Lu".findoneof("I Love Lucee"));
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[FindOneOf()](../../functions/findoneof.md), [String](../string.md)