# string.findLastNoCase()

Finds the last occurrence of a substring in a string, from a
        specified start position. If substring is not in string,
        returns zero. The search is case-insensitive.

**Introduced:** 5.3.5.22

```
string.findLastNoCase( substring=string, start=number )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| substring | string | Yes | String for which to search. |  |
| start | number | No | End position of search from the left. |  |

# Examples

```cfml
string = "Susi Sorglos";
writeDump(string.findLastNoCase("s"));
writeDump(string.findLastNoCase("s",1));
writeDump(string.findLastNoCase("S",4));
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[FindLastNoCase()](../../functions/findlastnocase.md), [String](../string.md)