# string.find()

Finds the first occurrence of a `substring` in a `string`, from a specified start position.

The search is case-sensitive.

```
string.find( substring=string, start=number )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| substring | string | Yes | String for which to search. |  |
| start | number | No | Start position of search. |  |

# Examples

```cfml
	str="I love lucee";
	writeOutput(str.find('lucee'));//8
	writeOutput("<br>");
	strStart="Lucee COre Developer";
	writeOutput(strStart.find('o',3));//17
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[Find()](../../functions/find.md), [String](../string.md)