# string.filter()

Filters a string to its elements for which the callback function returns true.

**Introduced:** 6.0.0.105

```
string.filter( closure=function )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | Closure or a function reference that will be called for each of the iteration. *Alias: function, callback, udf* |  |

# Examples

```cfml
	letters = "abbcdB";
	callbackFunction = function(input){return input=="b";}

	result = letters.filter(callbackFunction);
	writeDump(result);

	result1 = "bob".filter(callbackFunction);
	writeDump(result1);
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[StringFilter()](../../functions/stringfilter.md), [String](../string.md)