# string.every()

Determines if all elements of a string satisfy a given condition.

**Introduced:** 6.0.0.105

```
string.every( closure=function )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | Closure or a function reference that will be called for each of the iteration. *Alias: function, callback, udf* |  |

# Examples

```cfml
	letters = "I love lucee";
	callbackFunction = function(input){return input=="e";}

	result = letters.every(callbackFunction);
	writeDump(result);
	result1 = "Eee".every(callbackFunction);
	writeDump(result1);
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[StringEvery()](../../functions/stringevery.md), [String](../string.md)