# string.encodeForLDAP()

Encodes the given string for safe output in LDAP queries.

```
string.encodeForLDAP( canonicalize=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| canonicalize | boolean | No | - If set to true, canonicalization happens before encoding. - If set to false, the given input string will just be encoded. The default value for canonicalize is false. When this parameter is not specified, canonicalization will not happen. By default, when canonicalization is performed, both mixed and multiple encodings will be allowed. To use any other combinations you should canonicalize using canonicalize method and then do encoding. |  |

# Examples

```cfml
str = "I ** love * lucee";

encode1 = str.encodeForLDAP();
dump(encode1);

encode2 =  "I ** love * lucee".encodeForLDAP();
dump(encode2);
```

# Categories

[Strings](../../../categories/string.md), [Encode/Decode](../../../categories/esapi.md), [LDAP](../../../categories/ldap.md)

# See Also

[EncodeForLDAP()](../../functions/encodeforldap.md), [String](../string.md)