# string.encodeForHTML()

Encodes the given string for safe output in HTML to stop Cross Site Scripting attacks.

```
string.encodeForHTML( canonicalize=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| canonicalize | boolean | No | If set to true, canonicalization happens before encoding. If set to false, the given input string will just be encoded. The default value for canonicalize is false. When this parameter is not specified, canonicalization will not happen. By default, when canonicalization is performed, both mixed and multiple encodings will be allowed. To use any other combinations you should canonicalize using canonicalize method and then do encoding. |  |

# Examples

```cfml
str = "<cfset>";
res = str.encodeForHTML();
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Encode/Decode](../../../categories/esapi.md), [HTML](../../../categories/html.md)

# See Also

[EncodeForHTML()](../../functions/encodeforhtml.md), [String](../string.md)