# string.each()

Iterates over a string and runs the closure function for each element in the string.

**Introduced:** 6.0.0.105

```
string.each( closure=function )
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | Closure or a function reference that will be called for each of the iteration. *Alias: function, callback, udf* |  |

# Examples

```cfml
	inputString="abcd";
	inputString.each(
		function(val) {
			writeoutput(val == "C");
		}
	);
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[StringEach()](../../functions/stringeach.md), [String](../string.md)