# string.deserializeJSON()

Converts a JSON (JavaScript Object Notation) string data representation into CFML data, such as a struct or array.

```
string.deserializeJSON( strictMapping=boolean, format=string )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| strictMapping | boolean | No | A Boolean value that specifies how to convert the JSON - TRUE Converts JSON structure strictly to CFML, using only JSON Datatypes - FALSE Query formats (like [SerializeJSON()](../../functions/serializejson.md) outputs) are converted back to CFML Queries |  |
| format | string | No | The format of the input string. Possible values are: - **json**: Standard JSON format - **json5**: JSON5 format which allows additional features such as comments and unquoted keys |  |

# Examples

```cfml
world = '{"save":"water","clean":"wastes"}';
res1 = deserializeJson(world);
writeDump(res1);
writeDump(res1.save);
writeDump(isstruct(res1));
```

# Categories

[Strings](../../../categories/string.md), [Parsing](../../../categories/parsing.md), [JSON](../../../categories/json.md), [JavaScript](../../../categories/javascript.md)

# See Also

[DeserializeJSON()](../../functions/deserializejson.md), [String](../string.md)