# string.compareNoCase()

Performs a case-insensitive comparison of two strings.
An indicator of the difference:

- A negative number, if string1 is less than string2
- 0, if string1 is equal to string2
- A positive number, if string1 is greater than string2

```
string.compareNoCase( string2=string )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string2 | string | Yes | A string or a variable that contains one |  |

# Examples

```cfml
	testOne = "100 MAIN ST.";
	dump(testOne.CompareNoCase("675 EAST AVENUE")); // -1
	writeoutput("<br>");
	testTwo = "I Love lucee";
	dump(testTwo.CompareNoCase("I Love Lucee")); // 0
	writeoutput("<br>");
	testThree = "Lucee";
	dump(testThree.CompareNoCase("developer")); // 1
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[CompareNoCase()](../../functions/comparenocase.md), [String](../string.md)