# string.compare()

Performs a case-sensitive comparison of two strings.

- -1, if string1 is less than string2
- 0, if string1 is equal to string2
- 1, if string1 is greater than string2

```
string.compare( string2=string )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string2 | string | Yes | A string or a variable that contains one |  |

# Examples

```cfml
	testOne = "Lucee";
	dump(testOne.Compare("lucee")); // -1
	writeoutput("<br>");
	testTwo = "Lucee_Core_dev";
	dump(testTwo.Compare("Lucee_Core_dev")); // 0
	writeoutput("<br>");
	testThree = "I Love lucee";
	dump(testThree.Compare("I Love Lucee")); // 1
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[Compare()](../../functions/compare.md), [String](../string.md)