# string.cJustify()

Returns the given string justified to the center, padding out the words with spaces accordingly

```
string.cJustify( length=number )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| length | number | Yes | A positive integer. Length of field. |  |

# Examples

```cfml
	str = cJustify("ColdFusion", 35)
	writeDump(str.len());

	writeoutput("<hr>");
	s = "";
	res = s.cJustify(4);
	writeDump(len(res)); // length is 4
	writeoutput("<pre>|#res#|</pre><hr>");

	s = "abc";
	res = s.cJustify(10);
	writeDump(len(res)); // length is 10
	writeoutput("<pre>|#res#|</pre><hr>");

	s = "10";
	res = s.cJustify(8);
	writeDump(len(res)); // length is 8
	writeoutput("<pre>|#res#|</pre>");

```

# Categories

[Strings](../../../categories/string.md), [Formatting](../../../categories/formatting.md)

# See Also

[CJustify()](../../functions/cjustify.md), [String](../string.md)