# String

Object

- [string.asc()](string/asc.md) - Determines the value of a character.
- [string.cJustify()](string/cjustify.md) - Returns the given string justified to the center, padding out the words with spaces accordingly
- [string.compare()](string/compare.md) - Performs a case-sensitive comparison of two strings.
-1, if string1 is less than string2
0, if string1 is equal to string2
1, if string1 is greater than string2
- [string.compareNoCase()](string/comparenocase.md) - Performs a case-insensitive comparison of two strings.
An indicator of the difference:
A negative number, if string1 is less than string2
0, if string1 is equal to string2
A positive number, if string1 is greater than string2
- [string.decodeForHTML()](string/decodeforhtml.md) - Decodes the given encoded string.
- [string.decodeFromURL()](string/decodefromurl.md) - Decodes a string that has been encoded in the URL using the encodeForURL.
this function is deprecated, use function ESAPIDecode('url',...) instead.
- [string.deserializeJSON()](string/deserializejson.md) - Converts a JSON (JavaScript Object Notation) or JSON5 string data representation into CFML data, such as a struct or array.
- [string.each()](string/each.md) - Iterates over a string and runs the closure function for each element in the string.
- [string.encodeForCSS()](string/encodeforcss.md) - Encodes the given string for safe output in CSS to reduce the risk of Cross Site Scripting attacks.
- [string.encodeForDN()](string/encodefordn.md) - Encodes the given string for safe output in LDAP Distinguished Names.
- [string.encodeForHTML()](string/encodeforhtml.md) - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- [string.encodeForHTMLAttribute()](string/encodeforhtmlattribute.md) - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- [string.encodeForJavascript()](string/encodeforjavascript.md) - Encodes the given string for safe output in JavaScript to reduce the risk of Cross Site Scripting attacks.
- [string.encodeForLDAP()](string/encodeforldap.md) - Encodes the given string for safe output in LDAP queries.
- [string.encodeForSQL()](string/encodeforsql.md) - Encodes the given string for safe output in a query to reduce the risk of SQL Injection attacks. _This method is not recommended_ - the use of query parameters are strongly encouraged as a stronger alternative.
- [string.encodeForURL()](string/encodeforurl.md) - Encodes the given string for safe output in a URL.
- [string.encodeForXML()](string/encodeforxml.md) - Encodes the given string for safe output in XML to reduce the risk of Cross Site Scripting attacks.
- [string.encodeForXMLAttribute()](string/encodeforxmlattribute.md) - Encodes the given string for safe output in XMLAttribute to reduce the risk of Cross Site Scripting attacks.
- [string.encodeForXPath()](string/encodeforxpath.md) - Encodes the given string for safe use in an XPath Query.
- [string.encrypt()](string/encrypt.md) - Encrypts a string. Uses a symmetric key-based algorithm, in
which the same key is used to encrypt and decrypt a string.
The security of the encrypted string depends on maintaining
the secrecy of the key. Uses an XOR-based algorithm that uses
a pseudo-random 32-bit key, based on a seed passed by the user
as a function parameter.
- [string.every()](string/every.md) - Determines if all elements of a string satisfy a given condition.
- [string.filter()](string/filter.md) - Filters a string to its elements for which the callback function returns true.
- [string.find()](string/find.md) - Finds the first occurrence of a substring in a string, from a
specified start position. The search is case-sensitive.
- [string.findLast()](string/findlast.md) - Finds the last occurrence of a substring in a string, from a
specified start position. The search is case-sensitive.
- [string.findLastNoCase()](string/findlastnocase.md) - Finds the last occurrence of a substring in a string, from a
specified start position. If substring is not in string,
returns zero. The search is case-insensitive.
- [string.findNoCase()](string/findnocase.md) - Finds the first occurrence of a substring in a string, from a
specified start position. If substring is not in string,
returns zero. The search is case-insensitive.
- [string.findOneOf()](string/findoneof.md) - Finds the first occurrence of any one of a set of characters
in a string, from a specified start position. The search is
case-sensitive.
- [string.getToken()](string/gettoken.md) - Determines whether a token of the list in the delimiters
parameter is present in a string.
Returns the token found at position index of the string, as a
string. If index is greater than the number of tokens in the
string, returns an empty string.
- [string.hash()](string/hash.md) - Converts a variable-length string to a 32-byte, hexadecimal
string, using the MD5 algorithm. (It is not possible to convert
the hash result back to the source string.)
32-byte, hexadecimal string
- [string.insert()](string/insert.md) - Inserts a substring in a string after a specified character
position. If position = 0, prefixes the substring to the
string.
- [string.lCase()](string/lcase.md) - Converts the alphabetic characters in a string to lowercase.
- [string.left()](string/left.md) - Returns a substring from beginning of the input string, with a length specified by the count argument.
- [string.len()](string/len.md) - returns the len of a string
- [string.listAppend()](string/listappend.md) - Concatenates a list or element to a list.
- [string.listAvg()](string/listavg.md) - Calculates average from all numeric values given in the list
- [string.listChangeDelims()](string/listchangedelims.md) - Changes a list delimiter.
Returns a copy of the list, with each delimiter character
replaced by new_delimiter.
- [string.listCompact()](string/listcompact.md) - Removes any empty items from the start and end of the list
- [string.listContains()](string/listcontains.md) - Determines the index of the first list element that contains a
specified substring.
Returns the index of the first list element that contains
substring. If not found, returns zero.
- [string.listContainsNoCase()](string/listcontainsnocase.md) - Determines the index of the first list element that contains a
specified substring.
- [string.listDeleteAt()](string/listdeleteat.md) - Deletes an element from a list.
Returns a copy of the list, without the specified element.
- [string.listEach()](string/listeach.md) - call the given UDF/Closure with every value in the string list.
- [string.listEvery()](string/listevery.md) - This function calls a given closure/function with every element in a given string list and returns true, if all of the closure calls returns true.
- [string.listFilter()](string/listfilter.md) - This function creates a new string list that returns all entries from an string list that match the given filter.
- [string.listFind()](string/listfind.md) - Determines the index of the first list element in which a
specified value occurs. Case-sensitive
- [string.listFindNoCase()](string/listfindnocase.md) - Determines the index of the first list element in which a
specified value occurs
- [string.listFirst()](string/listfirst.md) - Gets the first element of a list.
- [string.listGetAt()](string/listgetat.md) - Gets a list element at a specified position.
- [string.listGetDuplicates()](string/listgetduplicates.md) - Gets a list of duplicate values from a list.
- [string.listIndexExists()](string/listindexexists.md) - Determines if an element at the given position exists or not
- [string.listInsertAt()](string/listinsertat.md) - Inserts an element in a list.
- [string.listItemTrim()](string/listitemtrim.md) - Removes all the white space surrounding each element, returning back the new list
- [string.listLast()](string/listlast.md) - Gets the last element of a list.
- [string.ListLen()](string/listlen.md) - Determines the number of elements in a list.
- [string.listMap()](string/listmap.md) - Calls the given closure with every element in the given list.
The function returns a list that contains all values returned by the closure.
- [string.listPrepend()](string/listprepend.md) - Inserts an element at the beginning of a list.
- [string.listQualifiedToArray()](string/listqualifiedtoarray.md) - Copies the elements of a list to an array.
- [string.listQualify()](string/listqualify.md) - Inserts a string at the beginning and end of list elements.
- [string.listReduce()](string/listreduce.md) - Iterates over every entry of the given list and calls the closure with every element. 
This function will reduce the list to a single value and will return the value.
- [string.listRemoveDuplicates()](string/listremoveduplicates.md) - Removes duplicate values from list.
- [string.listRest()](string/listrest.md) - Gets a list, without its first element.
- [string.listSetAt()](string/listsetat.md) - Replaces the contents of a list element.
- [string.listSome()](string/listsome.md) - This function calls a given closure/function with every element in a given string list and returns true, if one of the closure calls returns true.
- [string.listSort()](string/listsort.md) - Sorts list elements according to a sort type and sort order.
- [string.listToArray()](string/listtoarray.md) - Copies the elements of a list to an array.
- [string.listValueCount()](string/listvaluecount.md) - Counts instances of a specified value in a list. The search is
case-sensitive.
- [string.listValueCountNoCase()](string/listvaluecountnocase.md) - Counts instances of a specified value in a list. The search is
case-insensitive.
- [string.lJustify()](string/ljustify.md) - Left justifies characters in a string of a specified length.
- [string.ltrim()](string/ltrim.md) - Removes leading spaces from a string.
- [string.map()](string/map.md) - Iterates over every entry of the string and calls the closure function to work on the element of the string.
- [string.MarkdownToHTML()](string/markdowntohtml.md) - Transforms Markdown formatted String into HTML.
- [string.mid()](string/mid.md) - Extracts a substring from a string.
- [string.paragraphFormat()](string/paragraphformat.md) - Formats the carriage returns in a string to a HTML alternatives
- [string.parseDateTime()](string/parsedatetime.md) - Parses a date/time string according to the English (U.S.) locale conventions.
- [string.reduce()](string/reduce.md) - Iterates over every element of the string and calls the closure to work on the elements of the string. This function will reduce the string to a single value and will return the value.
- [string.reEscape()](string/reescape.md) - Escapes regular expression control characters within a string.
- [string.reFind()](string/refind.md) - Uses a regular expression (RE) to search a string for a pattern. The search is case sensitive.
- [string.reFindNoCase()](string/refindnocase.md) - Uses a regular expression (RE) to search a string for a pattern,
starting from a specified position. The search is
case-insensitive.
- [string.REMatch()](string/rematch.md) - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- [string.REMatchNoCase()](string/rematchnocase.md) - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- [string.removeChars()](string/removechars.md) - Removes characters from a string.
- [string.repeatString()](string/repeatstring.md) - Creates a string that contains a specified number of
repetitions of the specified string.
- [string.replace()](string/replace.md) - Replaces occurrences of substring1 in a string with substring2,
in a specified scope. The search is case-sensitive.
- [string.replaceList()](string/replacelist.md) - Replaces occurrences of the elements from a delimited list
in a string with corresponding elements from another delimited
list. The search is case-sensitive.
- [string.replaceListNoCase()](string/replacelistnocase.md) - Replaces occurrences of the elements from a delimited list
in a string with corresponding elements from another delimited
list. The search is NOT case-sensitive.
- [string.replaceNoCase()](string/replacenocase.md) - Replaces occurrences of substring1 with substring2, in the
specified scope. The search is case-insensitive.
- [string.rEReplace()](string/rereplace.md) - Uses a regular expression (RE) to search a string for a string
pattern and replace it with another. The search is
case-sensitive.
- [string.rEReplaceNoCase()](string/rereplacenocase.md) - Uses a regular expression to search a string for a string
pattern and replace it with another. The search is
case-insensitive.
- [string.reverse()](string/reverse.md) - Reverses the order of items, such as the characters in a
string, the digits in a number, or the elements in an array.
- [string.right()](string/right.md) - Returns a substring from end of the input string, with a length specified by the count argument.
- [string.rJustify()](string/rjustify.md) - Right justifies characters of a string.
- [string.rtrim()](string/rtrim.md) - Removes spaces from the end of a string.
- [string.sanitizeHTML()](string/sanitizehtml.md) - Sanitizes unsafe HTML input and removes elements and attributes like JavaScript, onclick, etc.
See also https://github.com/OWASP/java-html-sanitizer
- [string.second()](string/second.md) - Detects and masks sensitive information (such as passwords, API keys, tokens, etc.) from a given string. 
The function identifies patterns commonly used for sensitive data and replaces them with a mask.
- [string.some()](string/some.md) - This function calls a given closure/function with every element in a given string and returns true, if one of the closure calls returns true.
- [string.sort()](string/sort.md) - Returns a string containing the sorted characters from the input.
- [string.spanExcluding()](string/spanexcluding.md) - Gets characters from a string, from the beginning to a
character that is in a specified set of characters. The
search is case-sensitive.
- [string.spanIncluding()](string/spanincluding.md) - Gets characters from a string, from the beginning to a
character that is not in a specified set of characters. The
search is case-sensitive.
- [string.stripCr()](string/stripcr.md) - Deletes return characters from a string.
- [string.toBase64()](string/tobase64.md) - Calculates the Base64 representation of a string or binary
object. The Base64 format uses printable characters, allowing
binary data to be sent in forms and e-mail, and stored in a
database or file.
- [string.trim()](string/trim.md) - Removes leading and trailing spaces from a string.
- [string.trimWhiteSpace()](string/trimwhitespace.md) - clean white space of the given string
- [string.uCase()](string/ucase.md) - Converts the alphabetic characters in a string to uppercase.
- [string.ucFirst()](string/ucfirst.md) - Capitalizes the first character of the given string.
- [string.uRLDecode()](string/urldecode.md) - Decodes a URL-encoded string, converting encoded characters back to their original form. 
This function handles URL encoding conventions such as converting plus signs (`+`) to spaces and percent-encoded sequences (`%xx`) to their corresponding characters.
The function throws an exception when encountering malformed URL encodings (such as incomplete or invalid percent sequences like `%G`). 
For optimal results, ensure the input string contains valid URL encoding.
- [string.URLEncode()](string/urlencode.md) - Encodes a string to be URL-safe according to the application/x-www-form-urlencoded MIME format
- [string.uRLEncodedFormat()](string/urlencodedformat.md) - Generates a URL-encoded string. For example, it replaces spaces
with %20, and non-alphanumeric characters with equivalent
hexadecimal escape sequences. Passes arbitrary strings within a
URL.
- [string.wrap()](string/wrap.md) - Wraps text so that each line has a specified maximum number of characters.

# Categories

[Objects](../../categories/object.md), [Strings](../../categories/string.md)