# query.ToStruct()

Copy the query columns data to struct by using the columnKey argument

**Introduced:** 6.0.0.302

```
query.ToStruct( columnKey=string, structType=string, valueRowNumber=boolean )
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| columnKey | string | Yes | Column name that values are used for struct key *Alias: column, columnName* |  |
| structType | string | No | default:ordered, Struct type to created *Alias: type* |  |
| valueRowNumber | boolean | No | default: false, the boolean value that indicates the struct values return as column data or row number *Alias: valueAsRowNumber* |  |

# Examples

```cfml
qry = query(
    id: [ 1, 2, 3, 4 ],
    name: [ "mssql", "mysql", "image", "pdf" ],
    version: [ "7.2.2.jre8", "8.0.30", "1.0.0.42", "1.1.0.7" ]
);
basic = qry.ToStruct("name");
dump( var=basic, label="basic (ordered)");

normal = qry.ToStruct( "version", "normal", false);
dump( var=normal, label="normal (unordered)");

row = qry.ToStruct( "version", "normal", true);
dump( var=row, label="valueRowNumber=true,unordered");

member = qry.ToStruct("id");
dump(var=member, label="member");
```

# Categories

[Queries](../../../categories/query.md), [Structures](../../../categories/struct.md)

# See Also

[QueryToStruct()](../../functions/querytostruct.md), [Query](../query.md)