# query.setCell()

Sets a cell to a value. If no row number is specified, the cell on the last row is set.

You can also use [query.addRow()](addrow.md) to add a new row with data.

```
query.setCell( column_name=string, value=any, row_number=number )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| column_name | string | Yes | Name of the column to update *Alias: columnName* |  |
| value | any | Yes | New value for the cell |  |
| row_number | number | No | Which row to update, defaults to the the last row in the query *Alias: row, number* |  |

# Examples

```cfml
q = queryNew( "id,name");
q.addRow();

q.setCell("id", 1, 1);
q.setCell("name", "one", 1);

dump(q);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryAddRow()](../../functions/queryaddrow.md), [QuerySetCell()](../../functions/querysetcell.md), [Query](../query.md)