# query.rowSwap()

swaps one row of a query with an other.

**Introduced:** 6.0.0.17

```
query.rowSwap( source=numeric, destination=numeric )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| source | numeric | Yes | The row to swap. *Alias: sourceRow, src* |  |
| destination | numeric | Yes | The row to be swapped with. *Alias: destinationRow, dest, target* |  |

# Examples

```cfml
    qry = queryNew("id,name", "integer,varchar",
    [
        [1, "a"],
        [2, "b"],
        [3, "c"]
    ]);

    dump(qry);
    swapped = qry.rowSwap(2,3)
    dump(swapped);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryRowSwap()](../../functions/queryrowswap.md), [Query](../query.md)