# query.rowData()

Returns a struct with the data from a query for a given row number

```
query.rowData( rowNumber=number, format=string )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| rowNumber | number | Yes | position of the row to be returned |  |
| format | string | No | struct or array *Alias: returnFormat* |  |

# Examples

```cfml
q = queryNew( "id,name","int,varchar");
q.addRow(4);
q.setCell("id", 1, 1);
q.setCell("id", 2, 2);
q.setCell("id", 3, 3);
q.setCell("id", 4, 4);
q.setCell("name", "one", 1);
q.setCell("name", "two", 2);
q.setCell("name", "three",3);
q.setCell("name", "four", 4);
dump(q);
writeDump(q.rowdata(2));
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryRowData()](../../functions/queryrowdata.md), [Query](../query.md)