# query.rowByIndex()



**Introduced:** 5.3.4.34

```
query.rowByIndex( index=string, defaultValue=numeric )
```

**Returns:** numeric

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| index | string | Yes | Name of the index. |  |
| defaultValue | numeric | No | In case no matching index was found, this value is returned by the function, in case it is not set, the function will throw an exception. |  |

# Examples

```cfml
<cfscript>
    q_tag = queryNew("tag,id")
    tags = getTagList();
    loop collection="#tags.cf#" item="tag" {
        res = queryAddRow(q_tag);
        QuerySetCell(q_tag, "tag", tag, res);
        QuerySetCell(q_tag, "id", res, res);
    }
</cfscript>

<cfquery name="q_tags_indexed" indexName="tag" dbtype="query">
    select * from q_tag;
</cfquery>

<cfscript>
    writeDump(q_tags_indexed.rowByIndex("tag",5));
</cfscript>
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryRowByIndex()](../../functions/queryrowbyindex.md), [Query](../query.md)