# query.renameColumn()

Rename a column

**Introduced:** 6.0.0.57

```
query.renameColumn( column=string, newColumnName=string )
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| column | string | Yes | Name of the column to rename. *Alias: columnName* |  |
| newColumnName | string | Yes | New name of the column. |  |

# Examples

```cfml
    qry= queryNew( "name , age" , "varchar , integer" , [ [ "Susi" , 20 ] , [ "Urs", 24 ] ]);

    writeOutput("Before changing the QueryColumn name : ");
    writeDump(qry);

    qry.renameColumn( "name", "employee" );

    writeOutput("After changing the QueryColumn name : ");
    writeDump(qry);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryRenameColumn()](../../functions/queryrenamecolumn.md), [Query](../query.md)