# query.prepend()

Adds all values of one query the begin to another query. Both queries need to have the same columns.

**Introduced:** 6.0.0.15

```
query.prepend( query2=query )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query2 | query | Yes | query to get data from. |  |

# Examples

```cfml
    testQuery = queryNew( "name , age" , "varchar , numeric" , { name: [ "Susi" , "Urs" ] , age: [ 20 , 24 ] } );
    newTestQuery = queryNew( "name , age" , "varchar , numeric" , [ [ "Smith" , 20 ] , [ "John", 24 ] ]);
    testQuery.prepend(newTestQuery);
    writeDump(testQuery);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryPrepend()](../../functions/queryprepend.md), [Query](../query.md)