# query.map()

Calls the given closure with every row in the given query.

the function returns a query that contains all values returned by the closure.

```
query.map( closure=function, resQuery=query, parallel=boolean, maxThreads=number )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | filter can be a function/closure that implements the following constructor `function(struct row[, number rowNumber, query query]):struct`. The returned struct is used to fill a single query row. *Alias: function, callback, udf* |  |
| resQuery | query | No | Resulted query. *Alias: resultingQuery* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	people = QueryNew( "name,dob,age", "varchar,date,int", [
	    [ "Susi", CreateDate( 1970, 1, 1 ), 0 ],
	    [ "Urs" , CreateDate( 1995, 1, 1 ), 0 ],
	    [ "Fred", CreateDate( 1960, 1, 1 ), 0 ],
	    [ "Jim" , CreateDate( 1988, 1, 1 ), 0 ]
	]);
	Dump( var=people, label="people - original query" );
	/* Output:
	| name | dob                 | age |
	------------------------------------
	| Susi | 1970-01-01 00:00:00 | 0   |
	| Urs  | 1995-01-01 00:00:00 | 0   |
	| Fred | 1960-01-01 00:00:00 | 0   |
	| Jim  | 1988-01-01 00:00:00 | 0   |
	*/
	people = people.map( function( row, rowNumber, recordset ){
	    row['age'] = DateDiff( 'yyyy', row.dob, Now() );
	    return row;
	});
	Dump( var=people, label='people - with calculated age' );
	/* Output:
	| name | dob                 | age |
	------------------------------------
	| Susi | 1970-01-01 00:00:00 | 45  |
	| Urs  | 1995-01-01 00:00:00 | 20  |
	| Fred | 1960-01-01 00:00:00 | 55  |
	| Jim  | 1988-01-01 00:00:00 | 27  |
	*/
```

# Categories

[Iterator](../../../categories/iterator.md), [Queries](../../../categories/query.md), [Threads](../../../categories/thread.md)

# See Also

[QueryMap()](../../functions/querymap.md), [Query](../query.md)