# query.keyExists()

Determines whether a specific column is present in a query.

```
query.keyExists( column=string )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| column | string | Yes | Key to be matched with the columns. |  |

# Examples

```cfml
q = queryNew( "id,name","int,varchar");
q.addRow(4);
q.setCell("id", 1, 1);
q.setCell("id", 2, 2);
q.setCell("id", 3, 3);
q.setCell("id", 4, 4);
q.setCell("name", "one", 1);
q.setCell("name", "two", 2);
q.setCell("name", "three",3);
q.setCell("name", "four", 4);
dump(q);
writedump(q.keyExists("id"));
writedump(q.keyExists("name"));
writedump(q.keyExists("title"));
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryKeyExists()](../../functions/querykeyexists.md), [Query](../query.md)