# query.insertAt()

Adds data (query,struct or array) into query.

**Introduced:** 6.0.0.16

```
query.insertAt( value=any, index=numeric )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | data to insert, can be a query, a struct or an array. |  |
| index | numeric | Yes | position to insert data into, existing data get moved to the "right". |  |

# Examples

```cfml
    qry1 = queryNew( "name, age", "varchar, integer",
        [
            [ "Susi", 20 ],
            [ "Urs", 24 ],
            [ "Smith", 21 ],
            [ "John", 26 ]
        ]);
    qry2 = queryNew( "name, age", "varchar, integer",
        [
            [ "Jeni", 19 ]
        ]);
    writeOutput("Before QueryInsert :");    
    writeDump(qry1);

    qry1.insertAt( qry2, 3 );

    writeOutput("After QueryInsert :");
    writeDump(qry1);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryInsertAt()](../../functions/queryinsertat.md), [Query](../query.md)