# query.getCell()

return the value of a specific query cell

```
query.getCell( column_name=string, row_number=number )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| column_name | string | Yes | name of the column |  |
| row_number | number | No | row number (1-n) |  |

# Examples

```cfml
q = queryNew( "id,name","int,varchar");
q.addRow(4);
q.setCell("id", 1, 1);
q.setCell("id", 2,2);
q.setCell("id", 3,3);
q.setCell("id", 4,4);
q.setCell("name", "one", 1);
q.setCell("name", "two", 2);
q.setCell("name", "three",3);
q.setCell("name", "four", 4);
dump(q);
writeDump(q.getcell("id",1));
writeDump(q.getcell("name",3));
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryGetCell()](../../functions/querygetcell.md), [Query](../query.md)