# query.filter()

This function creates a new Query that returns all rows from an query that match the given filter.

```
query.filter( filter=function, parallel=boolean, maxThreads=number )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| filter | function | Yes | A function/closure that implements the following constructor `function(struct row[, number rowNumber, query query]) { return true/false; }` for best performance, use scoped variables, like `arguments.row`, instead of just `row` |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
<cfscript>
	q = QueryNew("name, description");
	loop times=3 {
		getFunctionList().each(function(f){
			var fd = getFunctionData(arguments.f);
			var r =QueryAddRow(q);
			QuerySetCell(q,"name", fd.name, r);
			QuerySetCell(q,"description", fd.description, r);
		});
	}
	dump(var=q.recordcount,
	    label="demo data set size");
	s = "the";
</cfscript>

<cftimer type="outline" label="Query of Query">
	<cfquery dbtype="query" name="q1">
		select 	name, description
		from 	q
		where 	description like <cfqueryparam value='%#s#%' cfsqltype="varchar">
	</cfquery>
</cftimer>
<cfdump var=#q1.recordcount#>

<cftimer type="outline" label="query.filter() with scoped variables">
	<cfscript>
		q2 = q.filter(function(row){
			return (arguments.row.description contains s);
		});
	</cfscript>
</cftimer>
<cfdump var=#q2.recordcount#>

<cftimer type="outline" label="query.filter() without unscoped variables">
	<cfscript>
		q3 = q.filter(function(row){
			return (row.description contains s);
		});
	</cfscript>
</cftimer>
<cfdump var=#q3.recordcount#>

```

# Categories

[Iterator](../../../categories/iterator.md), [Queries](../../../categories/query.md), [Threads](../../../categories/thread.md)

# See Also

[QueryFilter()](../../functions/queryfilter.md), [Query](../query.md)