# query.every()

This function calls a given closure/function with every element in a given query and returns true, if all of the closure calls returns true.

```
query.every( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor `function(struct row [number rownumber, query query]) { returns boolean; ).` *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	people = QueryNew( "name,dob,age", "varchar,date,int", [
		[ "Susi", CreateDate( 1970, 1, 1 ), 0 ],
		[ "Urs" , CreateDate( 1995, 1, 1 ), 0 ],
		[ "Fred", CreateDate( 1960, 1, 1 ), 0 ],
		[ "Jim" , CreateDate( 1988, 1, 1 ), 0 ]
	]);
	valid = people.Every(function(row, rowNumber, qryData){
	    return ((DateDiff('yyyy', row.dob, Now()) > 0) && (DateDiff('yyyy', row.dob, Now()) <= 100))
	});
	writeDump(valid);
```

# Categories

[Iterator](../../../categories/iterator.md), [Queries](../../../categories/query.md), [Threads](../../../categories/thread.md)

# See Also

[QueryEvery()](../../functions/queryevery.md), [Query](../query.md)