# query.each()

call the given UDF/Closure with every row (struct) in the query.

```
query.each( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | A closure function (UDF) with the following signature: `function( row, rowNumber, recordset ){}` Which is called for each row in the query. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	qry = queryNew( "id, name","cf_sql_integer, cf_sql_varchar", [ [ 1, "Tricia" ],[ 2, "Sarah" ],[ 3, "Joanna" ]] );
	writeDump(qry);
	testQueryEach='';
	qry.Each(function(struct row,numeric rowNumber,query query){
		testQueryEach&=row.id&":"&row.name&":"&rowNumber&';';
	});
	writeDump(testQueryEach);
```

# Categories

[Iterator](../../../categories/iterator.md), [Queries](../../../categories/query.md), [Threads](../../../categories/thread.md)

# See Also

[QueryEach()](../../functions/queryeach.md), [Query](../query.md)