# query.deleteRow()

Deletes the row within a query object. Modifies the original query object

For ACF compatibility, starting with version 6.0.0.207, the member function `query.deleteRow()` returns the updated query (allowing method chaining). see [LDEV-3581](https://luceeserver.atlassian.net/browse/LDEV-3581)

```
query.deleteRow( row=number )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| row | number | No | The query row number to be deleted. |  |

# Examples

```cfml
q = queryNew( "id,name","int,varchar");
q.addRow(4);
q.setCell("id", 1, 1);
q.setCell("id", 2,2);
q.setCell("id", 3,3);
q.setCell("id", 4,4);
q.setCell("name", "one", 1);
q.setCell("name", "two", 2);
q.setCell("name", "three",3);
q.setCell("name", "four", 4);
dump(q);
writeDump(q.deleterow(2));
writeDump(q.deleterow(3));
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryDeleteRow()](../../functions/querydeleterow.md), [Query](../query.md)