# query.deleteColumn()

Removes a column from a query and returns the query without the specified column.

For ACF compatibility, starting with version 6.0.0.207, the member function `query.deleteColumn()` returns the updated query (allowing method chaining). see [LDEV-3581](https://luceeserver.atlassian.net/browse/LDEV-3581)

```
query.deleteColumn( column=String )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| column | String | Yes | Specify the column name to delete from query |  |

# Examples

```cfml
q = queryNew( "id,name","int,varchar",[{"id":"1","name":"one"},{"id":"2","name":"two"}]);
dump(q);
writeDump(q.deletecolumn("id"));
writeDump(q);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryDeleteColumn()](../../functions/querydeletecolumn.md), [Query](../query.md)