# query.columnList()

return the column names as list

```
query.columnList( delimiter=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| delimiter | string | No | delimiter used to separate elements in list |  |

# Examples

```cfml
q = queryNew( "id,name","int,varchar");
q.addRow(4);
q.setCell("id", 1, 1);
q.setCell("id", 2,2);
q.setCell("id", 3,3);
q.setCell("id", 4,4);
q.setCell("name", "one", 1);
q.setCell("name", "two", 2);
q.setCell("name", "three",3);
q.setCell("name", "four", 4);
dump(q);
writeDump(q.columnlist());
writeDump(q.columnlist("2"));
writeDump(q.columnlist("@"));
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryColumnList()](../../functions/querycolumnlist.md), [Query](../query.md)