# query.columnData()

Returns all the data in a query for a given column

```
query.columnData( columnName=string, closure=function )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| columnName | string | Yes | name of the column returned |  |
| closure | function | No | UDF/Closure that call with the values from column *Alias: function, callback, udf* |  |

# Examples

```cfml
q = queryNew( "id,name","int,varchar",[{"id":"1","name":"one"},{"id":"2","name":"two"}]);
dump(q);
writeDump(q.columndata("name"));
writeDump(q.columndata("id"));
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryColumnData()](../../functions/querycolumndata.md), [Query](../query.md)