# query.append()

Adds all values of one query to the end of another query. Both queries need to have the same columns.

**Introduced:** 6.0.0.15

```
query.append( query2=query )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query2 | query | Yes | query to get data from. |  |

# Examples

```cfml
    testQuery = queryNew( "name , age" , "varchar , numeric" , { name: [ "Susi" , "Urs" ] , age: [ 20 , 24 ] } );
    newTestQuery = queryNew( "name , age" , "varchar , numeric" , [ [ "Smith" , 20 ] , [ "John", 24 ] ]);
    testQuery.append(newTestQuery);
    writeDump(testQuery);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryAppend()](../../functions/queryappend.md), [Query](../query.md)