# query.addRow()

Adds a specified number of empty rows to a query.

Lucee 6 changed the return value from the number of rows, to the modified query, to match ACF

```
query.addRow( numberOrData=any )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| numberOrData | any | No | Number of rows to add to the query or a struct/array containing the data tp populate the row. Examples: - ```queryAddRow(qry, 3);``` - ```queryAddRow(qry, ["Susi", 20] );``` - ```queryAddRow(qry, {name: "Susi", age: 20} );``` *Alias: number, data* |  |

# Examples

```cfml
myQuery    = queryNew( "id,name");
addedRows  = myQuery.addRow( 3 ); // will return 3

myQuery.addRow([17,'added via array notation']);

anotherRow = myQuery.addRow();    // will return 4

myQuery.addRow({
    id:18,
    name:'added via struct notation'
});
dump(myQuery);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryAddRow()](../../functions/queryaddrow.md), [QuerySetCell()](../../functions/querysetcell.md), [Query](../query.md)