# query.addColumn()

Adds a column to a query and populates its rows with the contents of an one-dimensional array.

Pads query columns, if necessary, to ensure that all columns have the same number of rows.

For ACF compatibility, starting with version 6.0.0.207, the member function `query.addColumn()` returns the updated query (allowing method chaining). see [LDEV-3581](https://luceeserver.atlassian.net/browse/LDEV-3581)

```
query.addColumn( column=string, datatype_or_array=any, array=any )
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| column | string | Yes | Name of the new column. *Alias: columnName* |  |
| datatype_or_array | any | No | Column data type. *Alias: datatype* |  |
| array | any | No | Name of an array whose elements populate the new column. |  |

# Examples

```cfml
	myquery = querynew("id,name");
	myquery.addrow();
	myquery.setcell("id","1");
	myquery.setcell("name","item1");
	myquery.addRow();
	myquery.setcell("id","2");
	myquery.setcell("name","item2");
	myquery.addColumn("age",listtoarray("20,21"));
	myquery.addColumn("class",listtoarray("A,B"));
	writeDump(myquery);
```

# Categories

[Queries](../../../categories/query.md)

# See Also

[QueryAddColumn()](../../functions/queryaddcolumn.md), [Query](../query.md)