# Query

Object

- [query.addColumn()](query/addcolumn.md) - Adds a column to a query and populates its rows with the
contents of a one-dimensional array. Pads query columns,
if necessary, to ensure that all columns have the same number
of rows.
- [query.addRow()](query/addrow.md) - Adds a specified number of empty rows to a query.
- [query.append()](query/append.md) - Adds all values of one query to the end of another query. Both queries need to have the same columns.
- [query.clear()](query/clear.md) - Clears all rows from a query
- [query.columnArray()](query/columnarray.md) - return the column names as array
- [query.columnCount()](query/columncount.md) - column count of given query
- [query.columnData()](query/columndata.md) - Returns all the data in a query for a given column
- [query.columnExists()](query/columnexists.md) - Determines whether a specific column is present in a query.
- [query.columnList()](query/columnlist.md) - return the column names as list
- [query.currentRow()](query/currentrow.md) - return the row where the pointer of the query is pointing ATM
- [query.deleteColumn()](query/deletecolumn.md) - removes a row from a query and return removed row as array
- [query.deleteRow()](query/deleterow.md) - Deletes the row within a query object. Modifies the original query object
- [query.each()](query/each.md) - call the given UDF/Closure with every row (struct) in the query.
- [query.every()](query/every.md) - This function calls a given closure/function with every element in a given query and returns true, if all of the closure calls returns true.
- [query.filter()](query/filter.md) - This function creates a new Query that returns all rows from an query that match the given filter.
- [query.getCell()](query/getcell.md) - return the value of a specific query cell
- [query.getCellByIndex()](query/getcellbyindex.md) - return the value of a specific query cell
- [query.getRow()](query/getrow.md) - this function is deprecated, use function QueryRowData instead.
- [query.insertAt()](query/insertat.md) - Adds data (query,struct or array) into query.
- [query.isEmpty()](query/isempty.md) - returns query empty or not
- [query.keyExists()](query/keyexists.md) - Determines whether a specific column is present in a query.
- [query.map()](query/map.md) - Calls the given closure with every row in the given query.
the function returns a query that contains all values returned by the closure.
- [query.prepend()](query/prepend.md) - Adds all values of one query the begin to another query. Both queries need to have the same columns.
- [query.recordCount()](query/recordcount.md) - row count of given query
- [query.reduce()](query/reduce.md) - Iterates over every row of the given query and calls the closure with that row. 
This function will reduce the query to a single value and will return this value.
- [query.renameColumn()](query/renamecolumn.md) - Rename a column
- [query.reverse()](query/reverse.md) - reverse the row order of a complete query
- [query.rowByIndex()](query/rowbyindex.md) - 
- [query.rowData()](query/rowdata.md) - Returns a struct with the data from a query for a given row number
- [query.rowDataByIndex()](query/rowdatabyindex.md) - 
- [query.rowSwap()](query/rowswap.md) - swaps one row of a query with an other.
- [query.setCell()](query/setcell.md) - Sets a cell to a value. If no row number is specified, the cell on the last row is set.
- [query.setRow()](query/setrow.md) - Adds a row to a query, either by struct or array
- [query.slice()](query/slice.md) - creates a new query containing a part of the given query
- [query.some()](query/some.md) - This function calls a given closure/function with every element in a given query and returns true, if one of the closure calls returns true.
- [query.sort()](query/sort.md) - Sorts the query based on the column specified and the order criteria given. Modifies the original query object
- [query.ToStruct()](query/tostruct.md) - Copy the query columns data to struct by using the columnKey argument

# Categories

[Objects](../../categories/object.md), [Queries](../../categories/query.md)

# See Also

[QueryNew()](../functions/querynew.md)