# numeric.bitMaskSet()

Performs a bitwise mask set operation.

```
numeric.bitMaskSet( mask=number, start=number, length=number )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| mask | number | Yes | integer mask |  |
| start | number | Yes | Integer, in the range 0-31, inclusive; start bit for mask |  |
| length | number | Yes | Integer, in the range 0-31, inclusive; length of mask |  |

# Examples

```cfml
	writeDump(10.0.bitmaskset(1,2,1));
	writeDump(5.0.bitmaskset(1,1,1));
```

# Categories

[Numbers](../../../categories/number.md), [Math](../../../categories/math.md)

# See Also

[BitMaskSet()](../../functions/bitmaskset.md), [numeric](../numeric.md)