# numeric.bitMaskRead()

Performs a bitwise mask read operation.
Returns an integer, created from length bits of number,
beginning at start.

```
numeric.bitMaskRead( start=number, length=number )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| start | number | Yes | Integer, in the range 0-31, inclusive; start bit for read |  |
| length | number | Yes | Integer, in the range 0-31, inclusive; length of mask |  |

# Examples

```cfml
	writeOutput(255.0.bitMaskRead(5, 5)); writeOutput("<br>"); writeOutput(255.0.bitMaskRead(0, 4));
```

# Categories

[Numbers](../../../categories/number.md), [Math](../../../categories/math.md)

# See Also

[BitMaskRead()](../../functions/bitmaskread.md), [numeric](../numeric.md)