# numeric.bitMaskClear()

Performs a bitwise mask clear operation.

```
numeric.bitMaskClear( start=number, length=number )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| start | number | Yes | Integer, in the range 0-31, inclusive; start bit for mask |  |
| length | number | Yes | Integer, in the range 0-31, inclusive; length of mask |  |

# Examples

```cfml
number = 255;
writeOutput(number.bitMaskClear(5, 5));
writeOutput("<br>");
writeOutput(255.1.bitMaskClear(0, 4));
```

# Categories

[Numbers](../../../categories/number.md), [Math](../../../categories/math.md)

# See Also

[BitMaskClear()](../../functions/bitmaskclear.md), [numeric](../numeric.md)