# image.writeBase64()

Writes Base64 images to the specified filename and destination.

```
image.writeBase64( destination=string, format=string, inHTMLFormat=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| destination | string | Yes | The path for the destination file. |  |
| format | string | Yes | the image format |  |
| inHTMLFormat | boolean | No | Specify whether Base64 output includes the headers used by the Base64 images in the HTML "img" tag ("data:image/{format};base64,...") : - true - false (default) |  |

# Examples

```cfml
	imgObj = imageNew("",200,200,"rgb","red");
	imgObj.writeBase64('base64.txt','jpg','true');
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageWriteBase64()](../../functions/imagewritebase64.md), [Image](../image.md)