# image.write()

Writes a image to the specified filename or destination.

```
image.write( destination=string, quality=number, overwrite=boolean, noMetaData=boolean )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| destination | string | No | The path to write the file. If you create the image with the ImageNew function or another operation where you do not specify the filename, specify the destination parameter. The file format is derived from the extension of the filename. The default value for this parameter is the filename of the original image source. |  |
| quality | number | No | Defines the JPEG quality used to encode the image. This parameter applies only to destination files with an extension of JPG or JPEG. Valid values are fractions that range from 0 through 1 (the lower the number, the lower the quality). The default value is 0.75. |  |
| overwrite | boolean | No | If set to true (default), overwrites the destination file. |  |
| noMetaData | boolean | No | if true the meta data from the source file are ignored. |  |

# Examples

```cfml
	newImg = imageNew("",200,200,"rgb","red");
	newImg.write("picture.png",1,true);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageWrite()](../../functions/imagewrite.md), [Image](../image.md)