# image.translateDrawingAxis()

Translates the origin of the image context to the point (x,y) in the current coordinate system.
Modifies the image context so that its new origin corresponds to the point (x,y) in the image's original coordinate system.

```
image.translateDrawingAxis( x=number, y=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | x coordinate |  |
| y | number | Yes | y coordinate |  |

# Examples

```cfml
	imgObj = imageNew("",200,200,"rgb","149c82");
	imgObj.translateDrawingAxis(20,20);
	imgObj.drawRect(50,50,70,50,"yes");
	cfimage(action="writeToBrowser", source=imgObj);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageTranslateDrawingAxis()](../../functions/imagetranslatedrawingaxis.md), [Image](../image.md)