# image.translate()

Copies an image to a new location on the plane.

```
image.translate( xTrans=number, yTrans=number, interpolation=string )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| xTrans | number | Yes | Displacement in the x direction. |  |
| yTrans | number | Yes | Displacement in the y direction. |  |
| interpolation | string | No | Type of interpolation: - nearest (default): Applies the nearest neighbor method of interpolation. Image quality is lower than the other interpolation methods, but processing is fastest. - bilinear: Applies the bilinear method of interpolation. The quality of the image is less pixelated than the default, but processing is slower. - bicubic: Applies the bicubic method of interpolation. Generally, the quality of image is highest with this method and processing is slowest. |  |

# Examples

```cfml
	imgObj = imageNew("",200,200,"rgb","149c82");
	imgObj.translate(40,40);
	imgObj.drawRect(50,50,70,50,"yes");
	cfimage(action="writeToBrowser", source=imgObj);
	imgObj.translate(40,40);
	cfimage(action="writeToBrowser", source=imgObj);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageTranslate()](../../functions/imagetranslate.md), [Image](../image.md)