# image.shearDrawingAxis()

Shears the drawing canvas.

```
image.shearDrawingAxis( shx=number, shy=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| shx | number | Yes | The multiplier by which coordinates are shifted in the positive x axis direction as a function of the y coordinate. |  |
| shy | number | Yes | the multiplier by which coordinates are shifted in the positive y axis direction as a function of the x coordinate. |  |

# Examples

```cfml
	img = imageNew("",152,152,"rgb","149c82");
	img.shearDrawingAxis(0.5,0.5);
	imagedrawRect(img,40,50,70,50,"yes");
	cfimage(action="writeToBrowser", source=img);
	img.shearDrawingAxis(0.5,0.5);
	imageDrawOval(img,60,50,50,100,"no");
	cfimage(action="writeToBrowser", source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageShearDrawingAxis()](../../functions/imagesheardrawingaxis.md), [Image](../image.md)